<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section3
#  Version : R2.0.8.S04                                   
#  Intermediate release number : 036-20200706                                
#  Last update : 14/04/2016                                                      
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
	<!--PATTERN -->
	<xsl:template match="*[@FORM='1'][.//attribute::CTYPE!='WORKS']//MAIN_FINANCING_CONDITIONS" mode="R166">
		<xsl:choose>
			<xsl:when test="not(descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+'))"/>
			<xsl:otherwise>
				<xsl:variable name="ele">CTYPE='<xsl:value-of select="//attribute::CTYPE"/>' and MAIN_FINANCING_CONDITIONS inconsistent</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R166'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R166"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R166"/>
	<xsl:template match="@*|node()" priority="-2" mode="R166">
		<xsl:apply-templates select="@*|*" mode="R166"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='12'][.//attribute::VALUE='DIRECTIVE_2004_18'][.//RESTRICTED_CONTEST]" mode="R167">
		<xsl:choose>
			<xsl:when test="descendant::CRITERIA_SELECTION_PARTICIPANTS[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(DIRECTIVE_2004_18) CRITERIA_SELECTION_PARTICIPANTS missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R167'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R167"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R167"/>
	<xsl:template match="@*|node()" priority="-2" mode="R167">
		<xsl:apply-templates select="@*|*" mode="R167"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='7']" mode="R168">
		<xsl:choose>
			<xsl:when test="descendant::CONDITIONS_ECONOMIC_OPERATORS[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]
                and descendant::METHODS_CONDITIONS[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">{CONDITIONS_ECONOMIC_OPERATORS,METHODS_CONDITIONS} missing/empty</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R168'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R168"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R168"/>
	<xsl:template match="@*|node()" priority="-2" mode="R168">
		<xsl:apply-templates select="@*|*" mode="R168"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='2' or @FORM='5']" mode="R169">
		<xsl:choose>
			<xsl:when test="descendant::MAIN_FINANCING_CONDITIONS[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">MAIN_FINANCING_CONDITIONS missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R169'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R169"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R169"/>
	<xsl:template match="@*|node()" priority="-2" mode="R169">
		<xsl:apply-templates select="@*|*" mode="R169"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='2' or @FORM='5']//EXISTENCE_OTHER_PARTICULAR_CONDITIONS|ANNEX_I//PARTICULAR_CONDITIONS" mode="R170">
		<xsl:choose>
			<xsl:when test="descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="@FORM='2' or @FORM='5'">EXISTENCE_OTHER_PARTICULAR_CONDITIONS</xsl:when>
						<xsl:otherwise>PARTICULAR_CONDITIONS</xsl:otherwise>
					</xsl:choose> empty</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R170'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R170"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R170"/>
	<xsl:template match="@*|node()" priority="-2" mode="R170">
		<xsl:apply-templates select="@*|*" mode="R170"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='2' or @FORM='10']" mode="R171">
		<xsl:choose>
			<xsl:when test="(descendant::ECONOMIC_OPERATORS_PERSONAL_SITUATION|descendant::PERSONAL_SITUATION)               
                [descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="@FORM='2'">ECONOMIC_OPERATORS_PERSONAL_SITUATION</xsl:when>
						<xsl:otherwise>PERSONAL_SITUATION</xsl:otherwise>
					</xsl:choose> missing/empty</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R171'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R171"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R171"/>
	<xsl:template match="@*|node()" priority="-2" mode="R171">
		<xsl:apply-templates select="@*|*" mode="R171"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='12']" mode="R172">
		<xsl:choose>
			<xsl:when test="descendant::NO_PARTICIPATION_RESERVED_PROFESSION|descendant::PARTICIPATION_RESERVED_PROFESSION               
                [descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="not(descendant::PARTICIPATION_RESERVED_PROFESSION)">NO_PARTICIPATION_RESERVED_PROFESSION/PARTICIPATION_RESERVED_PROFESSION missing</xsl:when>
						<xsl:otherwise>PARTICIPATION_RESERVED_PROFESSION empty</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R172'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R172"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R172"/>
	<xsl:template match="@*|node()" priority="-2" mode="R172">
		<xsl:apply-templates select="@*|*" mode="R172"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='5'][//attribute::VALUE='RESTRICTED' or //attribute::VALUE='NEGOTIATED']" mode="R173">
		<xsl:choose>
			<xsl:when test="descendant::ECONOMIC_OPERATORS_PERSONAL_SITUATION[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="descendant::*[@VALUE='RESTRICTED' or @VALUE='NEGOTIATED']/@VALUE"/> procedure and missing/empty ECONOMIC_OPERATORS_PERSONAL_SITUATION</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R173'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R173"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R173"/>
	<xsl:template match="@*|node()" priority="-2" mode="R173">
		<xsl:apply-templates select="@*|*" mode="R173"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='11']" mode="R174">
		<xsl:choose>
			<xsl:when test="descendant::CONDITIONS_FOR_PARTICIPATION_LEFTI[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">CONDITIONS_FOR_PARTICIPATION_LEFTI missing/empty</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R174'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R174"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R174"/>
	<xsl:template match="@*|node()" priority="-2" mode="R174">
		<xsl:apply-templates select="@*|*" mode="R174"/>
	</xsl:template>
	<!--PATTERN test-->
	<xsl:template match="*[@FORM='2' or @FORM='5' or @FORM='10']|*[@FORM='4'][ .//ANNEX_I]" mode="R175">
		<xsl:choose>
			<xsl:when test="descendant::EAF_CAPACITY_INFORMATION[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:when test=".[@FORM!='2']//*[matches(local-name(),'FINANCIAL_CAPACITY')][descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="@FORM='2'">EAF_CAPACITY_INFORMATION</xsl:when>
						<xsl:when test="@FORM='4'">(ANNEX_I) FINANCIAL_CAPACITY</xsl:when>
						<xsl:when test="@FORM='5'">F05_ECONOMIC_FINANCIAL_CAPACITY</xsl:when>
						<xsl:otherwise>FINANCIAL_CAPACITY</xsl:otherwise>
					</xsl:choose> missing/empty</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R175'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R175"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R175"/>
	<xsl:template match="@*|node()" priority="-2" mode="R175">
		<xsl:apply-templates select="@*|*" mode="R175"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='2' or @FORM='5' or @FORM='10']|*[@FORM='4'][ .//ANNEX_I]" mode="R176">
		<xsl:choose>
			<xsl:when test="descendant::T_CAPACITY_INFORMATION[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:when test="descendant::TECHNICAL_CAPACITY[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="@FORM='2'">T_CAPACITY_INFORMATION</xsl:when>
						<xsl:when test="@FORM='4'">(ANNEX_I) TECHNICAL_CAPACITY</xsl:when>
						<xsl:otherwise>TECHNICAL_CAPACITY</xsl:otherwise>
					</xsl:choose> missing/empty</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R176'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R176"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R176"/>
	<xsl:template match="@*|node()" priority="-2" mode="R176">
		<xsl:apply-templates select="@*|*" mode="R176"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='2' or @FORM='5'][.//TYPE_CONTRACT/@*='SERVICES']" mode="R177">
		<xsl:choose>
			<xsl:when test="(descendant::EXECUTION_SERVICE_RESERVED_PARTICULAR_PROFESSION   
                [descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]|descendant::NO_EXEC_SERVICE_RESERVED_PARTICULAR_PROFESSION) and
                descendant::REQUESTS_NAMES_PROFESSIONAL_QUALIFICATIONS"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="not(descendant::SERVICES_CONTRACTS_SPECIFIC_CONDITIONS[child::*])">NO_EXEC_SERVICE_RESERVED_PARTICULAR_PROFESSION/EXECUTION_SERVICE_RESERVED_PARTICULAR_PROFESSION/REQUESTS_NAMES_PROFESSIONAL_QUALIFICATIONS missing</xsl:when>
						<xsl:when test="descendant::REQUESTS_NAMES_PROFESSIONAL_QUALIFICATIONS and descendant::EXECUTION_SERVICE_RESERVED_PARTICULAR_PROFESSION">EXECUTION_SERVICE_RESERVED_PARTICULAR_PROFESSION empty</xsl:when>
						<xsl:when test="descendant::REQUESTS_NAMES_PROFESSIONAL_QUALIFICATIONS">NO_EXEC_SERVICE_RESERVED_PARTICULAR_PROFESSION/EXECUTION_SERVICE_RESERVED_PARTICULAR_PROFESSION missing</xsl:when>
						<xsl:otherwise>REQUESTS_NAMES_PROFESSIONAL_QUALIFICATIONS missing</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R177'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R177"/>
	</xsl:template>
	<xsl:template match="*[@FORM='2' or @FORM='5'][.//TYPE_CONTRACT/@*!='SERVICES'][.//SERVICES_CONTRACTS_SPECIFIC_CONDITIONS]" mode="R177">
		<xsl:variable name="ele">
			<xsl:value-of select=".//TYPE_CONTRACT/@*"/> and SERVICES_CONTRACTS_SPECIFIC_CONDITIONS/* inconsistent</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R177'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R177"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R177"/>
	<xsl:template match="@*|node()" priority="-2" mode="R177">
		<xsl:apply-templates select="@*|*" mode="R177"/>
	</xsl:template>
</xsl:stylesheet>
