<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section1
#  Version : R2.0.8.S04                                   
#  Intermediate release number : 036-20200706                               
#  Last update : 27/03/2020                                                      
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
	<xsl:template match="OFFICIALNAME[not(ancestor::MODIFIED_ADDRESS) and ancestor::CA_CE_CONCESSIONAIRE_PROFILE]" mode="R121">
		<xsl:choose>
			<xsl:when test="matches(text() ,'[^\n\r]*\w[^\n\r]*') "/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R121'"/>
					<xsl:with-param name="content" select="concat('OFFICIALNAME (',&quot;'&quot;,replace(text(),'[\t\n\r]+','[NL/TAB]'),&quot;'&quot;,')')"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R121"/>
	<xsl:template match="@*|node()" priority="-2" mode="R121">
		<xsl:apply-templates select="@*|*" mode="R121"/>
	</xsl:template>
	<xsl:template match="*[@FORM!='8']//CA_CE_CONCESSIONAIRE_PROFILE [not(ancestor::MODIFIED_ADDRESS)]" mode="R122">
		<xsl:choose>
			<xsl:when test="TOWN[matches( text() ,'[^\n\r]*\w[^\n\r]*') ] and ADDRESS[matches( text() ,'[^\n\r]*\w[^\n\r]*') ]"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R122'"/>
					<xsl:with-param name="content" select="concat('ADDRESS (',&quot;'&quot;,replace(ADDRESS/text(),'[\t\n\r]+','[NL/TAB]') ,&quot;'&quot;,') and TOWN (',&quot;'&quot;,replace(TOWN/text(),'[\t\n\r]+','[NL/TAB]') ,&quot;'&quot;,')')"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R122"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R122"/>
	<xsl:template match="@*|node()" priority="-2" mode="R122">
		<xsl:apply-templates select="@*|*" mode="R122"/>
	</xsl:template>
	<xsl:template match="*[@FORM!='8' and @FORM!='11']//CA_CE_CONCESSIONAIRE_PROFILE[not(ancestor::MODIFIED_ADDRESS)]" mode="R123">
		<xsl:choose>
			<xsl:when test=".//E_MAIL[matches( text() ,'\w')] "/>			
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R123'"/>
					<xsl:with-param name="content" select="'CA_CE_CONCESSIONAIRE_PROFILE//E_MAIL missing'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R123"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R123"/>
	<xsl:template match="@*|node()" priority="-2" mode="R123">
		<xsl:apply-templates select="@*|*" mode="R123"/>
	</xsl:template>
	<xsl:template match="*[@FORM='8']" mode="R124">
		<xsl:choose>
			<xsl:when test=".//URL_BUYER[matches( text() ,'\w')]"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R124'"/>
					<xsl:with-param name="content" select="'URL_BUYER missing'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R124"/>
	<xsl:template match="@*|node()" priority="-2" mode="R124">
		<xsl:apply-templates select="@*|*" mode="R124"/>
	</xsl:template>
	<xsl:template match="*[@FORM='7']" mode="R125">
		<xsl:choose>
			<xsl:when test=".//(URL_GENERAL|URL_BUYER|URL_INFORMATION|URL_PARTICIPATE)[matches( text() ,'\w')]"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R125'"/>
					<xsl:with-param name="content" select="'{URL_GENERAL,URL_BUYER,URL_INFORMATION,URL_PARTICIPATE} missing'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R125"/>
	<xsl:template match="@*|node()" priority="-2" mode="R125">
		<xsl:apply-templates select="@*|*" mode="R125"/>
	</xsl:template>
	<xsl:template match="*[@FORM='5'][.//@VALUE='OPEN']" mode="R126">
		<xsl:choose>
			<xsl:when test=".//SPECIFICATIONS_AND_ADDITIONAL_DOCUMENTS[child::IDEM or matches(descendant::text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R126'"/>
					<xsl:with-param name="content" select="'SPECIFICATIONS_AND_ADDITIONAL_DOCUMENTS missing'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R126"/>
	<xsl:template match="@*|node()" priority="-2" mode="R126">
		<xsl:apply-templates select="@*|*" mode="R126"/>
	</xsl:template>
	<xsl:template match="*[@FORM='11'or @FORM='12']" mode="R127">
		<xsl:choose>
			<xsl:when test=".//SPECIFICATIONS_AND_ADDITIONAL_DOCUMENTS[child::IDEM or matches(descendant::text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R127'"/>
					<xsl:with-param name="content" select="'SPECIFICATIONS_AND_ADDITIONAL_DOCUMENTS missing'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R127"/>
	<xsl:template match="@*|node()" priority="-2" mode="R127">
		<xsl:apply-templates select="@*|*" mode="R127"/>
	</xsl:template>
	<xsl:template match="*[@FORM='4'][.//NOTICE_CALL_COMPETITION or .//NOTICE_TIME_LIMITS_RECEIPT_TENDERS]|*[@FORM='5' or @FORM='10' or @FORM='11']" mode="R128R129R130">
		<xsl:choose>
			<xsl:when test=".//TENDERS_REQUESTS_APPLICATIONS_MUST_BE_SENT_TO[child::IDEM or matches(descendant::text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:when test="//*[@FORM='4']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R128'"/>
					<xsl:with-param name="content" select="'TENDERS_REQUESTS_APPLICATIONS_MUST_BE_SENT_TO missing'"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="//*[@FORM='10']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R130'"/>
					<xsl:with-param name="content" select="'TENDERS_REQUESTS_APPLICATIONS_MUST_BE_SENT_TO missing'"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R129'"/>
					<xsl:with-param name="content" select="'TENDERS_REQUESTS_APPLICATIONS_MUST_BE_SENT_TO missing'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R128R129R130"/>
	<xsl:template match="@*|node()" priority="-2" mode="R128R129R130">
		<xsl:apply-templates select="@*|*" mode="R128R129R130"/>
	</xsl:template>
	<xsl:template match="*[@FORM!='14'][.//@VALUE='DIRECTIVE_2004_17' or .//@NOTICE='PERIODIC_INDICATIVE_NOTICE' or .//@NOTICE='CONTRACTING_ENTITY']" mode="R131">
		<xsl:choose>
			<xsl:when test="not(.//TYPE_OF_CONTRACTING_AUTHORITY|.//TYPE_OF_CONTRACTING_AUTHORITY_OTHER[matches(text(),'[\p{L}\p{N}]+')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//*[@FORM='8']">TYPE_OF_CONTRACTING_AUTHORITY(_OTHER) and NOTICE_RELATION_PUBLICATION/@NOTICE=PERIODIC_INDICATIVE_NOTICE</xsl:when>
						<xsl:when test="//*[@FORM='15']">TYPE_OF_CONTRACTING_AUTHORITY(_OTHER) and NOTICE_PUBLISHED/@NOTICE=CONTRACTING_ENTITY</xsl:when>
						<xsl:otherwise>TYPE_OF_CONTRACTING_AUTHORITY(_OTHER) and NOTICE_COVERED/@VALUE=DIRECTIVE_2004_17</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R131'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R131"/>
	<xsl:template match="@*|node()" priority="-2" mode="R131">
		<xsl:apply-templates select="@*|*" mode="R131"/>
	</xsl:template>
	<xsl:template match="*[@FORM!='14'][.//@VALUE='DIRECTIVE_2004_17' or .//@NOTICE='PERIODIC_INDICATIVE_NOTICE' or .//@NOTICE='CONTRACTING_ENTITY']" mode="R132">
		<xsl:choose>
			<xsl:when test="not(.//TYPE_OF_ACTIVITY|.//TYPE_OF_ACTIVITY_OTHER[matches(text(),'[\p{L}\p{N}]+')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//*[@FORM='8']">TYPE_OF_ACTIVITY(_OTHER) and NOTICE_RELATION_PUBLICATION/@NOTICE=PERIODIC_INDICATIVE_NOTICE</xsl:when>
						<xsl:when test="//*[@FORM='15']">TYPE_OF_ACTIVITY(_OTHER) and NOTICE_PUBLISHED/@NOTICE=CONTRACTING_ENTITY</xsl:when>
						<xsl:otherwise>TYPE_OF_ACTIVITY(_OTHER) and NOTICE_COVERED/@VALUE=DIRECTIVE_2004_17</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R132'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R132"/>
	<xsl:template match="@*|node()" priority="-2" mode="R132">
		<xsl:apply-templates select="@*|*" mode="R132"/>
	</xsl:template>
	<xsl:template match="*[@FORM!='14'][.//@VALUE='DIRECTIVE_2004_18' or .//@NOTICE='PRIOR_INFORMATION_NOTICE' or .//@NOTICE='CONTRACTING_AUTHORITY']" mode="R133">
		<xsl:choose>
			<xsl:when test="not(.//ACTIVITY_OF_CONTRACTING_ENTITY|.//ACTIVITY_OF_CONTRACTING_ENTITY_OTHER[matches(text(),'[\p{L}\p{N}]+')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//*[@FORM='8']">ACTIVITY_OF_CONTRACTING_ENTITY(_OTHER) and NOTICE_RELATION_PUBLICATION/@NOTICE=PRIOR_INFORMATION_NOTICE</xsl:when>
						<xsl:when test="//*[@FORM='15']">ACTIVITY_OF_CONTRACTING_ENTITY(_OTHER) and NOTICE_PUBLISHED/@NOTICE=CONTRACTING_AUTHORITY</xsl:when>
						<xsl:otherwise>ACTIVITY_OF_CONTRACTING_ENTITY(_OTHER) and NOTICE_COVERED/@VALUE=DIRECTIVE_2004_18</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R133'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R133"/>
	<xsl:template match="@*|node()" priority="-2" mode="R133">
		<xsl:apply-templates select="@*|*" mode="R133"/>
	</xsl:template>
</xsl:stylesheet>
