<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!-- 
####################################################################################
#  XSL name : section6
#  Version : R2.0.8.S04                                        
#  Intermediate release number : 035-20200429                                  
#  Last update : 03/06/2016                                                          
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
	<!-- Pattern -->
	<xsl:template match="*[@FORM='2' or @FORM='5'][.//PT_NEGOTIATED_CHOICE | .//node()[string(@*)='NEGOTIATED']][.//IS_CANDIDATE_SELECTED[string(@*)='YES']]" mode="R231">
		<xsl:choose>
			<xsl:when test=".//ADDITIONAL_INFORMATION[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="@FORM='2'">(PT_NEGOTIATED_CHOICE, IS_CANDIDATE_SELECTED/@VALUE='YES') and missing ADDITIONAL_INFORMATION</xsl:when>
						<xsl:otherwise>(@VALUE='NEGOTIATED', IS_CANDIDATE_SELECTED/@VALUE='YES') and missing ADDITIONAL_INFORMATION</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R231'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R231"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R231"/>
	<xsl:template match="@*|node()" priority="-2" mode="R231">
		<xsl:apply-templates select="@*|*" mode="R231"/>
	</xsl:template>
	<!-- Pattern ProcedureForAppeal -->
	<xsl:template match="*[@FORM]" mode="R232R233">
		<xsl:choose>
			<xsl:when test=".[@FORM='1' or @FORM='8' or @FORM='9' or @FORM='11'or @FORM='14' or @FORM='16' or @FORM='19'] or .[@FORM='4'][not(descendant::ANNEX_I)] or .[@FORM='12' or @FORM='13'][.//attribute::VALUE='DIRECTIVE_2004_18'][not(descendant::APPEAL_PROCEDURES)] or .[@FORM='15'][not(descendant::PROCEDURES_FOR_APPEAL)]"/>
			<xsl:when test=".//*[
                (
                (descendant::APPEAL_PROCEDURE_BODY_RESPONSIBLE|descendant::RESPONSIBLE_FOR_APPEAL_PROCEDURES|descendant::BODY_RESPONSIBLE_APPEAL)
                [
                descendant::OFFICIALNAME[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::ADDRESS[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::TOWN[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::COUNTRY
                ] 
                or 
                (descendant::MEDIATION_PROCEDURE_BODY_RESPONSIBLE|descendant::RESPONSIBLE_FOR_MEDIATION_PROCEDURES|descendant::BODY_RESPONSIBLE_MEDIATION)
                [
                descendant::OFFICIALNAME[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::ADDRESS[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::TOWN[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::COUNTRY
                ] 
                ) 
                and 
                (
                (descendant::LODGING_APPEALS|descendant::INFO_ON_DEADLINE|descendant::LODGING_OF_APPEALS_PRECISION)               
                [
                descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')
                ] 
                or 
                (descendant::LODGING_INFORMATION_FOR_SERVICE|descendant::SERVICE_FROM_INFORMATION|descendant::SERVICE_INFORMATION_LODGING_APPEALS)
                [
                descendant::OFFICIALNAME[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::ADDRESS[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::TOWN[matches(text() ,'[\p{L}\p{N}]+')] and 
                descendant::COUNTRY
                ] 
                ) ]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="@FORM='4'">(ANNEX_I) PROCEDURES_APPEAL/* </xsl:when>
						<xsl:when test="@FORM='6' or @FORM='7' or @FORM='10' or @FORM='12' or @FORM='13'">APPEAL_PROCEDURES/* </xsl:when>
						<xsl:otherwise>PROCEDURES_FOR_APPEAL/* </xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="@FORM='15' or .[@FORM='12' or @FORM='13'][.//attribute::VALUE='DIRECTIVE_2004_18']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R233'"/>
							<xsl:with-param name="content" select="concat($ele, ' filled out incorrectly')"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R232'"/>
							<xsl:with-param name="content" select="concat($ele, 'missing / filled out incorrectly')"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R232R233"/>
	<xsl:template match="@*|node()" priority="-2" mode="R232R233">
		<xsl:apply-templates select="@*|*" mode="R232R233"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='1'][not(.//SUPPLIES)]" mode="R234">
		<xsl:choose>
			<xsl:when test=".//TAX_LEGISLATION//URL/text()"/>
			<xsl:when test=".//ENVIRONMENTAL_PROTECTION_LEGISLATION//URL/text()"/>
			<xsl:when test=".//EMPLOYMENT_PROTECTION_WORKING_CONDITIONS//URL/text()"/>
			<xsl:otherwise>
				<xsl:variable name="ele">missing TAX_LEGISLATION//URL, ENVIRONMENTAL_PROTECTION_LEGISLATION//URL or EMPLOYMENT_PROTECTION_WORKING_CONDITIONS//URL</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R234'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R234"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R234"/>
	<xsl:template match="@*|node()" priority="-2" mode="R234">
		<xsl:apply-templates select="@*|*" mode="R234"/>
	</xsl:template>
	<!---->
	<xsl:template match="NOTICE_DISPATCH_DATE/YEAR" mode="R709">
		<xsl:if test="not(matches(normalize-space(text()),'^20'))">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R709'"/>
				<xsl:with-param name="content" select="concat('NOTICE_DISPATCH_DATE/YEAR=', &quot;'&quot;, normalize-space(./text()), &quot;'&quot;)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R709"/>
	<xsl:template match="@*|node()" priority="-2" mode="R709">
		<xsl:apply-templates select="@*|*" mode="R709"/>
	</xsl:template>
</xsl:stylesheet>
